﻿#Requires -RunAsAdministrator

function parametre-Explorer {
    $AdminKey = "HKLM:\SOFTWARE\Microsoft\Active Setup\Installed Components\{A509B1A7-37EF-4b3f-8CFC-4F3A74704073}"
    $UserKey = "HKLM:\SOFTWARE\Microsoft\Active Setup\Installed Components\{A509B1A8-37EF-4b3f-8CFC-4F3A74704073}"
    Set-ItemProperty -Path $AdminKey -Name "IsInstalled" -Value 0 -Force
    Set-ItemProperty -Path $UserKey -Name "IsInstalled" -Value 0 -Force

    Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced" -Name "IconsOnly" -Type DWord -Value 0 

    Push-Location
    Set-Location HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced
    Set-ItemProperty . HideFileExt "0"
    Pop-Location

    Stop-Process -Name Explorer -Force
}

function Install-SQLCE {
	$arguments = "/i /passive"
	Start-Process -FilePath "SSCERuntime_x64-ENU.exe" -ArgumentList $arguments -Wait
}


function Install-IIS {

Set-ExecutionPolicy Bypass -Scope Process

DISM /Online /Enable-Feature /FeatureName:NetFx3 /All

Install-WindowsFeature -Name NET-Framework-Core, NET-HTTP-Activation
Install-WindowsFeature -name NET-WCF-HTTP-Activation45
Enable-WindowsOptionalFeature -Online -FeatureName IIS-WebServerRole
Enable-WindowsOptionalFeature -Online -FeatureName IIS-WebServer
Enable-WindowsOptionalFeature -Online -FeatureName IIS-CommonHttpFeatures
Enable-WindowsOptionalFeature -Online -FeatureName IIS-HttpErrors
Enable-WindowsOptionalFeature -Online -FeatureName IIS-HttpRedirect
Enable-WindowsOptionalFeature -Online -FeatureName IIS-ApplicationDevelopment

Enable-WindowsOptionalFeature -online -FeatureName NetFx4Extended-ASPNET45
Enable-WindowsOptionalFeature -Online -FeatureName IIS-NetFxExtensibility45

Enable-WindowsOptionalFeature -Online -FeatureName IIS-HealthAndDiagnostics
Enable-WindowsOptionalFeature -Online -FeatureName IIS-HttpLogging
Enable-WindowsOptionalFeature -Online -FeatureName IIS-LoggingLibraries
Enable-WindowsOptionalFeature -Online -FeatureName IIS-RequestMonitor
Enable-WindowsOptionalFeature -Online -FeatureName IIS-HttpTracing
Enable-WindowsOptionalFeature -Online -FeatureName IIS-Security
Enable-WindowsOptionalFeature -Online -FeatureName IIS-RequestFiltering
Enable-WindowsOptionalFeature -Online -FeatureName IIS-Performance
Enable-WindowsOptionalFeature -Online -FeatureName IIS-WebServerManagementTools
Enable-WindowsOptionalFeature -Online -FeatureName IIS-IIS6ManagementCompatibility
Enable-WindowsOptionalFeature -Online -FeatureName IIS-Metabase
Enable-WindowsOptionalFeature -Online -FeatureName IIS-ManagementConsole
Enable-WindowsOptionalFeature -Online -FeatureName IIS-BasicAuthentication
Enable-WindowsOptionalFeature -Online -FeatureName IIS-WindowsAuthentication
Enable-WindowsOptionalFeature -Online -FeatureName IIS-StaticContent
Enable-WindowsOptionalFeature -Online -FeatureName IIS-DefaultDocument
Enable-WindowsOptionalFeature -Online -FeatureName IIS-WebSockets
Enable-WindowsOptionalFeature -Online -FeatureName IIS-ApplicationInit
Enable-WindowsOptionalFeature -Online -FeatureName IIS-ISAPIExtensions
Enable-WindowsOptionalFeature -Online -FeatureName IIS-ISAPIFilter
Enable-WindowsOptionalFeature -Online -FeatureName IIS-HttpCompressionStatic
Enable-WindowsOptionalFeature -Online -FeatureName IIS-ASPNET45
Enable-WindowsOptionalFeature -Online -FeatureName IIS-ASP
Enable-WindowsOptionalFeature -Online -FeatureName IIS-ASPNET
Import-Module ServerManager
Add-WindowsFeature Web-Server, Web-Dyn-Compression
if ("True" -eq $webAccess)
{
	Start-Process 'dotnet-hosting-8.0.10-win.exe' '/passive' -Wait
}
}

function Set-ShortCut {
param ( [string]$SourcePath,[string]$SourceExe, [string]$DestinationPath )

$WshShell = New-Object -comObject WScript.Shell
$Shortcut = $WshShell.CreateShortcut($DestinationPath)
$ShortCut.WorkingDirectory = $SourcePath
$Shortcut.TargetPath = $SourcePath + '\' + $SourceExe
$Shortcut.Save()
}

function 7Zip-Unzip {
param ( [string]$7zf, [string]$DestinationDirPath )

	set-alias sz "$env:ProgramFiles\7-Zip\7z.exe"
	$7zo = "-aoa -r"
	sz x $7zf "-aoa" "-r" $("-o" + $DestinationDirPath)
}
function 7Zip-UnzipLocal {
param ( [string]$7zf, [string]$DestinationDirPath )

	set-alias sz "$env:ProgramFiles\7-Zip\7z.exe"
	sz x $7zf "-aoa" "-r"
}

Start-Transcript log.txt

if (Test-Path variable:global:tvtoolsDrive) {
	Remove-Variable tvtoolsDrive -Scope Global
}
if (Test-Path variable:global:mediasDrive) {
	Remove-Variable mediasDrive -Scope Global
}
if (Test-Path variable:global:sqlServer) {
	Remove-Variable sqlServer -Scope Global
}
if (Test-Path variable:global:sqlServerAccount) {
	Remove-Variable sqlServerAccount -Scope Global
}
if (Test-Path variable:global:webAccess) {
	Remove-Variable webAccess -Scope Global
}
if (Test-Path variable:global:mediasUrl) {
	Remove-Variable mediasUrl -Scope Global
}
if (Test-Path variable:global:serviceAccount) {
	Remove-Variable serviceAccount -Scope Global
}
if (Test-Path variable:global:modeHttps) {
	Remove-Variable modeHttps -Scope Global
}
if (Test-Path variable:global:httpsUser) {
	Remove-Variable httpsUser -Scope Global
}
if (Test-Path variable:global:httpsPassword) {
	Remove-Variable httpsPassword -Scope Global
}

Get-Content unattend.txt | Where-Object {$_.length -gt 0} | Where-Object {!$_.StartsWith("#")} | ForEach-Object {
     $var = $_.Split('=',2).Trim()
     New-Variable -Scope Global -Name $var[0] -Value $var[1]
}

if ("http://fqdn or IP/medias" -eq $mediasUrl)
{
	throw "you haven't set mediasUrl in unattend.txt. Please read carefully install documentation."
}

if (!(Test-Path "licenceTVTools.lic")) {
	Write-Host "Attention fichier licence non trouvée, la procédure va s'exécuter avec la licence de tests" -ForegroundColor Red
}

parametre-Explorer
Install-IIS

Start-Process rewrite_amd64_en-US.msi -ArgumentList "/quiet /passive"


$zipFile="$env:ProgramFiles\7-Zip\7z.exe"
if (!(Test-Path $zipFile)) {
    Write-Host "7Zip not found, install it"
    Start-Process "7-zip.exe" -Argumentlist '/S' -Wait
}

$dirname=$tvtoolsDrive + "tvtools"
if(!(Test-Path -Path $dirname)) {
    New-Item -ItemType directory -Path $dirname
}
TAKEOWN /f $dirname /r
iCACLS $dirname /Grant:r "Utilisateurs:(OI)(CI)M" /C /Q
iCACLS $dirname /Grant:r "Users:(OI)(CI)M" /C /Q

$dirname=$mediasDrive + "medias"
if(!(Test-Path -Path $dirname)) {
    New-Item -ItemType directory -Path $dirname
}
TAKEOWN /f $dirname /r
iCACLS $dirname /Grant:r "Utilisateurs:(OI)(CI)M" /C /Q
iCACLS $dirname /Grant:r "Users:(OI)(CI)M" /C /Q


7Zip-Unzip "Jr.zip" $tvtoolsDrive
7Zip-Unzip "serverSideJr.zip" $tvtoolsDrive
if ("True" -eq $webAccess)
{
	7Zip-Unzip "eval.zip" $mediasDrive
}

$filename=$tvtoolsDrive + "tvtools\prive\vcredist_x86.exe"
Start-Process -FilePath $filename -Argumentlist '/qb' -wait
$filename=$tvtoolsDrive + "tvtools\prive\VC_redist.x86.exe"
Start-Process -FilePath $filename -Argumentlist '/install /passive /norestart' -wait
$filename=$tvtoolsDrive + "tvtools\prive\VC_redist.x64.exe"
Start-Process -FilePath $filename -Argumentlist '/install /passive /norestart' -wait
Set-ShortCut "%windir%\System32\inetsrv" "InetMgr.exe" "$Home\Desktop\IIS Manager.lnk"
Set-ShortCut "%windir%\System32" "ServerManager.exe" "$Home\Desktop\ServerManager.lnk"
$filename=$tvtoolsDrive + "tvtools\TVTSchedulerFlat"
Set-ShortCut $filename "TVTScheduler.exe" "$Home\Desktop\TVTScheduler.lnk"

Install-SQLCE
if ("True" -eq $sqlServer)
{
	7Zip-UnzipLocal "SQLEXPRADV_x64_ENU.zip"
	cd "SQLEXPRADV_x64_ENU"
	if ("currentUser" -eq $sqlServerAccount)
	{
		$sqlServerAccount=$env:UserDomain + "\" + $env:UserName
	}
	.\SETUP.EXE /ConfigurationFile=ConfigurationFile.ini /SQLSYSADMINACCOUNTS=$sqlServerAccount
	cd ..
	Start-Process 'SSMS-Setup-ENU.exe' '/install /passive /norestart' -Wait
	$tvtoolsPriveFile=$tvtoolsDrive + "tvtools\prive\newCloudError.txt"
	if (Test-Path $tvtoolsPriveFile) {
		Remove-Item $tvtoolsPriveFile
	}
	$tvtoolsPriveFile=$tvtoolsDrive + "tvtools\prive\newCloud.txt"
	if (Test-Path $tvtoolsPriveFile) {
		Remove-Item $tvtoolsPriveFile
	}
	New-Item $tvtoolsPriveFile -ItemType file
	$mediasDriveValue="mediasPath=" + $mediasDrive + "Medias"
	$mediasUrlValue="mediasUrl=" + $mediasUrl
	$sqlServerAccountValue="sqlServerAccount=" + $sqlServerAccount
	$serviceAccountValue="serviceAccount=" + $serviceAccount
	$modeHttpsValue="modeHttps=" + $modeHttps
	$httpsUserValue="httpsUser=" + $httpsUser
	$httpsPasswordValue="httpsPassword=" + $httpsPassword

	Add-Content -Path $tvtoolsPriveFile -value $mediasDriveValue
	Add-Content -Path $tvtoolsPriveFile -value $mediasUrlValue
	Add-Content -Path $tvtoolsPriveFile -value $sqlServerAccountValue
	Add-Content -Path $tvtoolsPriveFile -value $serviceAccountValue
	Add-Content -Path $tvtoolsPriveFile -value $modeHttpsValue
	Add-Content -Path $tvtoolsPriveFile -value $httpsUserValue
	Add-Content -Path $tvtoolsPriveFile -value $httpsPasswordValue
}

if (Test-Path "licenceTVTools.lic") {
	$tvtoolsPriveDir=$tvtoolsDrive + "tvtools\prive"
	Copy-Item -Path "licenceTVTools.lic" -Destination $tvtoolsPriveDir
} else {
	$tvtoolsPriveDir=$tvtoolsDrive + "tvtools\prive\licenceTVTools.lic"
	Copy-Item -Path "licenceTVToolsDefaut.lic" -Destination $tvtoolsPriveDir
}


$curDir = Get-Location

$tvtoolsPriveFile=$tvtoolsDrive + "tvtools\TVTSchedulerFlat"
cd $tvtoolsPriveFile
Start-Process "TVTScheduler.exe" -Wait

$tvtoolsPriveFile=$tvtoolsDrive + "tvtools\prive\newCloudError.txt"
if (Test-Path $tvtoolsPriveFile) {
	$file_data = Get-Content $tvtoolsPriveFile
	Remove-Item $tvtoolsPriveFile
	Write-Host $file_data -ForegroundColor Red
	Write-Host "Procédure avortée" -ForegroundColor Red
} else {
cd $curDir
$TVTSchedulerUpdateDir=$mediasDrive + "Medias\TVTSchedulerUpdate"
If(!(test-path -PathType Container $TVTSchedulerUpdateDir))
{
     Write-Host "creating directory " $TVTSchedulerUpdateDir
     New-Item -ItemType Directory -Force -Path $TVTSchedulerUpdateDir
}
$TVTSchedulerUpdateFile=$TVTSchedulerUpdateDir + "\miseajour.zip"
Write-Host "copying jr.zip to " $TVTSchedulerUpdateFile
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Copy-Item -Path "jr.zip" -Destination $TVTSchedulerUpdateFile

$TVTSchedulerUpdateFile=$TVTSchedulerUpdateDir + "\7zS.sfx"
$sourceFile=$tvtoolsDrive + "tvtools\prive\dotNET\setupTVToolsServer\7zS.sfx"
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile

$TVTSchedulerUpdateFile=$TVTSchedulerUpdateDir + "\config.txt"
$sourceFile=$tvtoolsDrive + "tvtools\prive\dotNET\setupTVToolsServer\config.txt"
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile

$TVTSchedulerUpdateFile=$TVTSchedulerUpdateDir + "\TVTInstaller.exe"
$sourceFile=$tvtoolsDrive + "tvtools\prive\dotNET\setupTVToolsServer\TVTInstaller.exe"
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile

$TVTSchedulerUpdateFile=$TVTSchedulerUpdateDir + "\7za.exe"
$sourceFile=$tvtoolsDrive + "tvtools\prive\7za.exe"
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile

cd $TVTSchedulerUpdateDir
set-alias sz "$env:ProgramFiles\7-Zip\7z.exe"
sz a "miseajour.zip" -r tvtools
sz a -t7z installTVTools.7z miseajour.zip
sz a -t7z installTVTools.7z 7za.exe
sz a -t7z installTVTools.7z TVTInstaller.exe

cmd /c copy /b 7zS.sfx + config.txt + "installTVTools.7z" installClientTVTools.exe

Remove-Item 7zS.sfx
Remove-Item 7za.exe
Remove-Item config.txt
Remove-Item TVTInstaller.exe
Remove-Item installTVTools.7z

sz a "installClientTVTools.zip" installClientTVTools.exe

$TVTSchedulerUpdateFile=$curDir.Path + "\installClientTVTools.zip"
$sourceFile=$TVTSchedulerUpdateDir + "\installClientTVTools.zip"
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Write-Host "copying" $sourceFile "to" $TVTSchedulerUpdateFile
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile


$TVTSchedulerUpdateFile=$tvtoolsDrive + "tvtools\nv\Upload\tvtools\prive\temp"
If(!(test-path -PathType Container $TVTSchedulerUpdateFile))
{
     Write-Host "creating directory " $TVTSchedulerUpdateFile
     New-Item -ItemType Directory -Force -Path $TVTSchedulerUpdateFile
}
$TVTSchedulerUpdateFile=$tvtoolsDrive + "tvtools\nv\Upload\tvtools\prive\temp\miseajour.zip"
Write-Host "miseajour.zip to" $TVTSchedulerUpdateFile
Copy-Item -Path miseajour.zip -Destination $TVTSchedulerUpdateFile
sz d $TVTSchedulerUpdateFile configWebService.xml -r

$sourceFile=$tvtoolsDrive + "tvtools\prive\lancer.exe"
$TVTSchedulerUpdateFile=$tvtoolsDrive + "tvtools\nv\Upload\tvtools\prive\lancer.exe"
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile

Write-Host "URL pour obtenir l'installeur de client lourd et de diffusion Windows" -ForegroundColor Green
$monurl=$mediasUrl + "/TVTSchedulerUpdate/installClientTVTools.zip"
Write-Host $monurl -ForegroundColor Green

}
cd $curDir

Write-Host "Mise à jour terminée" -ForegroundColor Green

