﻿#Requires -RunAsAdministrator

function parametre-Explorer {
    $AdminKey = "HKLM:\SOFTWARE\Microsoft\Active Setup\Installed Components\{A509B1A7-37EF-4b3f-8CFC-4F3A74704073}"
    $UserKey = "HKLM:\SOFTWARE\Microsoft\Active Setup\Installed Components\{A509B1A8-37EF-4b3f-8CFC-4F3A74704073}"
    Set-ItemProperty -Path $AdminKey -Name "IsInstalled" -Value 0 -Force
    Set-ItemProperty -Path $UserKey -Name "IsInstalled" -Value 0 -Force

    Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced" -Name "IconsOnly" -Type DWord -Value 0 

    Push-Location
    Set-Location HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced
    Set-ItemProperty . HideFileExt "0"
    Pop-Location

    Stop-Process -Name Explorer -Force
}

function Install-SQLCE {
	$arguments = "/i /passive"
	Start-Process -FilePath "SSCERuntime_x64-FRA.exe" -ArgumentList $arguments -Wait
}


function Install-IIS {

Set-ExecutionPolicy Bypass -Scope Process

DISM /Online /Enable-Feature /FeatureName:NetFx3 /All
Install-WindowsFeature -Name NET-Framework-Core, NET-HTTP-Activation
Install-WindowsFeature -name NET-WCF-HTTP-Activation45

Enable-WindowsOptionalFeature -Online -FeatureName IIS-WebServerRole
Enable-WindowsOptionalFeature -Online -FeatureName IIS-WebServer
Enable-WindowsOptionalFeature -Online -FeatureName IIS-CommonHttpFeatures
Enable-WindowsOptionalFeature -Online -FeatureName IIS-HttpErrors
Enable-WindowsOptionalFeature -Online -FeatureName IIS-HttpRedirect
Enable-WindowsOptionalFeature -Online -FeatureName IIS-ApplicationDevelopment

Enable-WindowsOptionalFeature -online -FeatureName NetFx4Extended-ASPNET45
Enable-WindowsOptionalFeature -Online -FeatureName IIS-NetFxExtensibility45

Enable-WindowsOptionalFeature -Online -FeatureName IIS-HealthAndDiagnostics
Enable-WindowsOptionalFeature -Online -FeatureName IIS-HttpLogging
Enable-WindowsOptionalFeature -Online -FeatureName IIS-LoggingLibraries
Enable-WindowsOptionalFeature -Online -FeatureName IIS-RequestMonitor
Enable-WindowsOptionalFeature -Online -FeatureName IIS-HttpTracing
Enable-WindowsOptionalFeature -Online -FeatureName IIS-Security
Enable-WindowsOptionalFeature -Online -FeatureName IIS-RequestFiltering
Enable-WindowsOptionalFeature -Online -FeatureName IIS-Performance
Enable-WindowsOptionalFeature -Online -FeatureName IIS-WebServerManagementTools
Enable-WindowsOptionalFeature -Online -FeatureName IIS-IIS6ManagementCompatibility
Enable-WindowsOptionalFeature -Online -FeatureName IIS-Metabase
Enable-WindowsOptionalFeature -Online -FeatureName IIS-ManagementConsole
Enable-WindowsOptionalFeature -Online -FeatureName IIS-BasicAuthentication
Enable-WindowsOptionalFeature -Online -FeatureName IIS-WindowsAuthentication
Enable-WindowsOptionalFeature -Online -FeatureName IIS-StaticContent
Enable-WindowsOptionalFeature -Online -FeatureName IIS-DefaultDocument
Enable-WindowsOptionalFeature -Online -FeatureName IIS-WebSockets
Enable-WindowsOptionalFeature -Online -FeatureName IIS-ApplicationInit
Enable-WindowsOptionalFeature -Online -FeatureName IIS-ISAPIExtensions
Enable-WindowsOptionalFeature -Online -FeatureName IIS-ISAPIFilter
Enable-WindowsOptionalFeature -Online -FeatureName IIS-HttpCompressionStatic
Enable-WindowsOptionalFeature -Online -FeatureName IIS-ASPNET45
Enable-WindowsOptionalFeature -Online -FeatureName IIS-ASP
Enable-WindowsOptionalFeature -Online -FeatureName IIS-ASPNET
Import-Module ServerManager
if ("True" -eq $webAccess)
{
	Start-Process 'dotnet-hosting-8.0.10-win.exe' '/passive' -Wait
}
}

function Set-ShortCut {
    param (
        [string]$SourcePath,
        [string]$SourceExe, 
        [string]$DestinationPath,
        [string]$Arguments = "",
        [string]$IconLocation = "",
        [string]$Description = "",
        [switch]$RunAsAdmin
    )
    
    try {
        # Résoudre les variables d'environnement
        $SourcePath = [Environment]::ExpandEnvironmentVariables($SourcePath)
        $DestinationPath = [Environment]::ExpandEnvironmentVariables($DestinationPath)
        
        # Construire le chemin complet de l'exécutable
        $fullExePath = Join-Path -Path $SourcePath -ChildPath $SourceExe
        
        # Vérifier que l'exécutable existe
        if (-not (Test-Path $fullExePath)) {
            Write-Error "L'exécutable n'existe pas : $fullExePath"
            return $false
        }
        
        # Créer le répertoire de destination si nécessaire
        $destDir = Split-Path -Path $DestinationPath -Parent
        if (-not (Test-Path $destDir)) {
            New-Item -ItemType Directory -Path $destDir -Force | Out-Null
        }
        
        # Créer le raccourci
        $WshShell = New-Object -ComObject WScript.Shell
        $Shortcut = $WshShell.CreateShortcut($DestinationPath)
        $Shortcut.TargetPath = $fullExePath
        $Shortcut.WorkingDirectory = $SourcePath
        
        # Paramètres optionnels
        if ($Arguments) {
            $Shortcut.Arguments = $Arguments
        }
        
        if ($Description) {
            $Shortcut.Description = $Description
        }
        
        if ($IconLocation) {
            $Shortcut.IconLocation = [Environment]::ExpandEnvironmentVariables($IconLocation)
        }
        else {
            $Shortcut.IconLocation = $fullExePath + ",0"
        }
        
        # Sauvegarder le raccourci
        $Shortcut.Save()
        
        # Si RunAsAdmin est demandé, modifier le raccourci
        if ($RunAsAdmin) {
            $bytes = [System.IO.File]::ReadAllBytes($DestinationPath)
            $bytes[0x15] = $bytes[0x15] -bor 0x20 # Set byte 21 (0x15) bit 6 (0x20) ON
            [System.IO.File]::WriteAllBytes($DestinationPath, $bytes)
        }
        
        Write-Host "✓ Raccourci créé : $DestinationPath" -ForegroundColor Green
        
        # Libérer l'objet COM
        [System.Runtime.Interopservices.Marshal]::ReleaseComObject($WshShell) | Out-Null
        
        return $true
    }
    catch {
        Write-Error "Erreur lors de la création du raccourci : $_"
        return $false
    }
}
function 7Zip-Unzip {
param ( [string]$7zf, [string]$DestinationDirPath )

	set-alias sz "$env:ProgramFiles\7-Zip\7z.exe"
	$7zo = "-aoa -r"
	sz x $7zf "-aoa" "-r" $("-o" + $DestinationDirPath)
}
function 7Zip-UnzipLocal {
param ( [string]$7zf, [string]$DestinationDirPath )

	set-alias sz "$env:ProgramFiles\7-Zip\7z.exe"
	sz x $7zf "-aoa" "-r"
}

Start-Transcript log.txt

if (Test-Path variable:global:tvtoolsDrive) {
	Remove-Variable tvtoolsDrive -Scope Global
}
if (Test-Path variable:global:mediasDrive) {
	Remove-Variable mediasDrive -Scope Global
}
if (Test-Path variable:global:sqlServer) {
	Remove-Variable sqlServer -Scope Global
}
if (Test-Path variable:global:sqlServerAccount) {
	Remove-Variable sqlServerAccount -Scope Global
}
if (Test-Path variable:global:webAccess) {
	Remove-Variable webAccess -Scope Global
}
if (Test-Path variable:global:mediasUrl) {
	Remove-Variable mediasUrl -Scope Global
}
if (Test-Path variable:global:serviceAccount) {
	Remove-Variable serviceAccount -Scope Global
}


Get-Content unattend.txt | Where-Object {$_.length -gt 0} | Where-Object {!$_.StartsWith("#")} | ForEach-Object {
     $var = $_.Split('=',2).Trim()
     New-Variable -Scope Global -Name $var[0] -Value $var[1]
}

if ("http://fqdn or IP/medias" -eq $mediasUrl)
{
	throw "you haven't set mediasUrl in unattend.txt. Please read carefully install documentation."
}

if (!(Test-Path "licenceTVTools.lic")) {
	Write-Host "Attention fichier licence non trouvée, la procédure va s'exécuter avec la licence de tests" -ForegroundColor Red
}

parametre-Explorer
Install-IIS
Start-Process rewrite_amd64_en-US.msi -ArgumentList "/quiet /passive"


$zipFile="$env:ProgramFiles\7-Zip\7z.exe"
if (!(Test-Path $zipFile)) {
    Write-Host "7Zip not found, install it"
    Start-Process "7-zip.exe" -Argumentlist '/S' -Wait
}

$dirname=$tvtoolsDrive + "tvtools"
if(!(Test-Path -Path $dirname)) {
    New-Item -ItemType directory -Path $dirname
}
TAKEOWN /f $dirname /r
iCACLS $dirname /Grant:r "Utilisateurs:(OI)(CI)M" /C /Q
iCACLS $dirname /Grant:r "Users:(OI)(CI)M" /C /Q

$dirname=$mediasDrive + "medias"
if(!(Test-Path -Path $dirname)) {
    New-Item -ItemType directory -Path $dirname
}
TAKEOWN /f $dirname /r
iCACLS $dirname /Grant:r "Utilisateurs:(OI)(CI)M" /C /Q
iCACLS $dirname /Grant:r "Users:(OI)(CI)M" /C /Q


7Zip-Unzip "Jr.zip" $tvtoolsDrive
7Zip-Unzip "serverSideJr.zip" $tvtoolsDrive
if ("True" -eq $webAccess)
{
	7Zip-Unzip "eval.zip" $mediasDrive
}

$filename=$tvtoolsDrive + "tvtools\prive\vcredist_x86.exe"
Start-Process -FilePath $filename -Argumentlist '/qb' -wait
$filename=$tvtoolsDrive + "tvtools\prive\VC_redist.x86.exe"
Start-Process -FilePath $filename -Argumentlist '/install /passive /norestart' -wait
$filename=$tvtoolsDrive + "tvtools\prive\VC_redist.x64.exe"
Start-Process -FilePath $filename -Argumentlist '/install /passive /norestart' -wait
Set-ShortCut "%windir%\System32\inetsrv" "InetMgr.exe" "$Home\Desktop\IIS Manager.lnk"
Set-ShortCut "%windir%\System32" "ServerManager.exe" "$Home\Desktop\ServerManager.lnk"
$filename=$tvtoolsDrive + "tvtools\TVTSchedulerFlat"
Set-ShortCut $filename "TVTScheduler.exe" "$Home\Desktop\TVTScheduler.lnk"

if ("True" -eq $sqlServer)
{
	7Zip-UnzipLocal "SQLServer2019ExpressAdvancedServices.zip"
	cd "SQLServer2019ExpressAdvancedServices"
	if ("currentUser" -eq $sqlServerAccount)
	{
		$sqlServerAccount=$env:UserDomain + "\" + $env:UserName
	}
	.\SETUP.EXE /ConfigurationFile=ConfigurationFile.ini /SQLSYSADMINACCOUNTS=$sqlServerAccount
	cd ..
	Start-Process 'SSMS-Setup-FRA.exe' '/install /passive /norestart' -Wait
}
Write-Host "First part OK, please install IIS Certifcate on server" -ForegroundColor Green
Write-Host "Copy certificate file to certif.pfx in installation directory." -ForegroundColor Green
Write-Host "Generate a certif.cer file based on this certicate, and copy it to installation directory." -ForegroundColor Green
Write-Host "Put certificate password in unattend.txt." -ForegroundColor Green
