﻿#Requires -RunAsAdministrator

$netVersion="$(
    switch ($release) {
        ({ $_ -ge 528040 }) { '4.8'; break }
        ({ $_ -ge 461808 }) { '4.7.2'; break }
        ({ $_ -ge 461308 }) { '4.7.1'; break }
        ({ $_ -ge 460798 }) { '4.7'; break }
        ({ $_ -ge 394802 }) { '4.6.2'; break }
        ({ $_ -ge 394254 }) { '4.6.1'; break }
        ({ $_ -ge 393295 }) { '4.6'; break }
        ({ $_ -ge 379893 }) { '4.5.2'; break }
        ({ $_ -ge 378675 }) { '4.5.1'; break }
        ({ $_ -ge 378389 }) { '4.5'; break }
        default { ':4.5+ not installed.' }
    }
)"

if(!("4.8" -eq $netVersion))
{
   cd "DotNet48"
   Powershell.exe -ExecutionPolicy Bypass .\Deploy-DotNet48.ps1 -DeploymentType "Install" -DeployMode "NonInteractive"
   throw "Please reboot Windows,then retry (install .net Framework 4.8 needs a reboot)"
}

function 7Zip-Unzip {
param ( [string]$7zf, [string]$DestinationDirPath )

	set-alias sz "$env:ProgramFiles\7-Zip\7z.exe"
	$7zo = "-aoa -r"
	sz x $7zf "-aoa" "-r" $("-o" + $DestinationDirPath)
}
function 7Zip-UnzipLocal {
param ( [string]$7zf, [string]$DestinationDirPath )

	set-alias sz "$env:ProgramFiles\7-Zip\7z.exe"
	sz x $7zf "-aoa" "-r"
}

if (Test-Path variable:global:tvtoolsDrive) {
	Remove-Variable tvtoolsDrive -Scope Global
}
if (Test-Path variable:global:mediasDrive) {
	Remove-Variable mediasDrive -Scope Global
}
if (Test-Path variable:global:webAccess) {
	Remove-Variable webAccess -Scope Global
}
if (Test-Path variable:global:webAccess) {
    Remove-Variable tvtschedulerService -Scope Global
}

Get-Content unattendUpdate.txt | Where-Object {$_.length -gt 0} | Where-Object {!$_.StartsWith("#")} | ForEach-Object {
     $var = $_.Split('=',2).Trim()
     New-Variable -Scope Global -Name $var[0] -Value $var[1]
}

$tvtoolsPriveFile=$tvtoolsDrive + "tvtools"
if (!(Test-Path $tvtoolsPriveFile)) {
	$file_data = $tvtoolsPriveFile + " n'existe pas! Merci de configurer unattendUpdate.txt"
	throw $file_data
}

$tvtoolsPriveFile=$mediasDrive + "Medias"
if (!(Test-Path $tvtoolsPriveFile)) {
	$file_data = $tvtoolsPriveFile + " n'existe pas! Merci de configurer unattendUpdate.txt"
	throw $file_data
}

$serviceUser="tvtcloud"
if ("True" -eq $tvtschedulerService)
{
    Write-Host "TVTSchedulerService found"
    $serviceName="TVTSchedulerService"
    If (Get-Service $serviceName -ErrorAction SilentlyContinue) {
        $serviceUser=(Get-WmiObject Win32_Service -Filter "Name='$serviceName'").StartName
        Write-Host "account for TVTSchedulerService = "  + $serviceUser

        taskkill /IM TVTSchedulerService.exe /f
        $service = Get-WmiObject -Class Win32_Service -Filter "Name='TVTSchedulerService'"
        $service.delete()
    }
} else {
    Write-Host "TVTSchedulerService not found, will be installed by TVTScheduler"
}

$tvtoolsPriveFile=$tvtoolsDrive + "tvtools\prive\updateCloud.txt"
if (Test-Path $tvtoolsPriveFile) {
    Remove-Item $tvtoolsPriveFile
}
New-Item $tvtoolsPriveFile -ItemType file
$tvtschedulerServiceValue="updateService=" + $tvtschedulerService
Add-Content -Path $tvtoolsPriveFile -value $tvtschedulerServiceValue
$serviceUserValue=""
if ("True" -eq $tvtschedulerService)
{
    $serviceUserValue="serviceUser=" + $serviceUser    
}
Add-Content -Path $tvtoolsPriveFile -value $serviceUserValue

$zipFile="$env:ProgramFiles\7-Zip\7z.exe"
if (!(Test-Path $zipFile)) {
    Write-Host "7Zip not found, install it"
    Start-Process "7-zip.exe" -Argumentlist '/S' -Wait
}

IISReset /STOP
taskkill /IM TVTScheduler.exe /f
taskkill /IM TVTSchedulerScannerLauncher.exe /f
taskkill /IM TVTSchedulerScanner.exe /f
taskkill /IM TVTSchedulerScanner2.exe /f
taskkill /IM TVTBooking.exe /f
taskkill /IM TVTBooking2.exe /f
taskkill /IM TVTSchedulerCommand.exe /f
IISReset /START

7Zip-Unzip "Jr.zip" $tvtoolsDrive
7Zip-Unzip "serverSideJr.zip" $tvtoolsDrive
if ("True" -eq $webAccess)
{
	7Zip-Unzip "evalUpdate.zip" $mediasDrive
}

$filename=$tvtoolsDrive + "tvtools\prive\VC_redist.x86.exe"
Start-Process -FilePath $filename -Argumentlist '/install /passive /norestart' -wait
$filename=$tvtoolsDrive + "tvtools\prive\VC_redist.x64.exe"
Start-Process -FilePath $filename -Argumentlist '/install /passive /norestart' -wait

$curDir = Get-Location

$tvtoolsPriveFile=$tvtoolsDrive + "tvtools\TVTSchedulerFlat"
cd $tvtoolsPriveFile
Start-Process "TVTScheduler.exe" -ArgumentList "-updateCloud" -Wait

$tvtoolsPriveFile=$tvtoolsDrive + "tvtools\prive\newCloudError.txt"
if (Test-Path $tvtoolsPriveFile) {
	$file_data = Get-Content $tvtoolsPriveFile
	Remove-Item $tvtoolsPriveFile
	Write-Host $file_data -ForegroundColor Red
	Write-Host "Procédure avortée" -ForegroundColor Red
} else {
cd $curDir
$TVTSchedulerUpdateDir=$mediasDrive + "Medias\TVTSchedulerUpdate"
If(!(test-path -PathType Container $TVTSchedulerUpdateDir))
{
     Write-Host "creating directory " $TVTSchedulerUpdateDir
     New-Item -ItemType Directory -Force -Path $TVTSchedulerUpdateDir
}
$TVTSchedulerUpdateFile=$TVTSchedulerUpdateDir + "\miseajour.zip"
Write-Host "copying jr.zip to " $TVTSchedulerUpdateFile
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Copy-Item -Path "jr.zip" -Destination $TVTSchedulerUpdateFile

$TVTSchedulerUpdateFile=$TVTSchedulerUpdateDir + "\7zS.sfx"
$sourceFile=$tvtoolsDrive + "tvtools\prive\dotNET\setupTVToolsServer\7zS.sfx"
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile

$TVTSchedulerUpdateFile=$TVTSchedulerUpdateDir + "\config.txt"
$sourceFile=$tvtoolsDrive + "tvtools\prive\dotNET\setupTVToolsServer\config.txt"
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile

$TVTSchedulerUpdateFile=$TVTSchedulerUpdateDir + "\TVTInstaller.exe"
$sourceFile=$tvtoolsDrive + "tvtools\prive\dotNET\setupTVToolsServer\TVTInstaller.exe"
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile

$TVTSchedulerUpdateFile=$TVTSchedulerUpdateDir + "\7za.exe"
$sourceFile=$tvtoolsDrive + "tvtools\prive\7za.exe"
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile

cd $TVTSchedulerUpdateDir
set-alias sz "$env:ProgramFiles\7-Zip\7z.exe"
sz a "miseajour.zip" -r tvtools
sz a -t7z installTVTools.7z miseajour.zip
sz a -t7z installTVTools.7z 7za.exe
sz a -t7z installTVTools.7z TVTInstaller.exe

cmd /c copy /b 7zS.sfx + config.txt + "installTVTools.7z" installClientTVTools.exe

Remove-Item 7zS.sfx
Remove-Item 7za.exe
Remove-Item config.txt
Remove-Item TVTInstaller.exe
Remove-Item installTVTools.7z

sz a "installClientTVTools.zip" installClientTVTools.exe

$TVTSchedulerUpdateFile=$curDir.Path + "\installClientTVTools.zip"
$sourceFile=$TVTSchedulerUpdateDir + "\installClientTVTools.zip"
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Write-Host "copying" $sourceFile "to" $TVTSchedulerUpdateFile
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile


$TVTSchedulerUpdateFile=$tvtoolsDrive + "tvtools\nv\Upload\tvtools\prive\temp"
If(!(test-path -PathType Container $TVTSchedulerUpdateFile))
{
     Write-Host "creating directory " $TVTSchedulerUpdateFile
     New-Item -ItemType Directory -Force -Path $TVTSchedulerUpdateFile
}
$TVTSchedulerUpdateFile=$tvtoolsDrive + "tvtools\nv\Upload\tvtools\prive\temp\miseajour.zip"
Write-Host "miseajour.zip to" $TVTSchedulerUpdateFile
Copy-Item -Path miseajour.zip -Destination $TVTSchedulerUpdateFile
sz d $TVTSchedulerUpdateFile configWebService.xml -r

$sourceFile=$tvtoolsDrive + "tvtools\prive\lancer.exe"
$TVTSchedulerUpdateFile=$tvtoolsDrive + "tvtools\nv\Upload\tvtools\prive\lancer.exe"
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile

Write-Host "URL pour obtenir l'installeur de client lourd et de diffusion Windows" -ForegroundColor Green
$monurl="url du serveur/TVTSchedulerUpdate/installClientTVTools.zip"
Write-Host $monurl -ForegroundColor Green

}
cd $curDir

Write-Host "Mise à jour terminée" -ForegroundColor Green

