/**
 * Configuration module. Holds all application settings. Because these parameters
 * can be overwritten by the configuration file, make sure each property is set as
 * a string. (regarding numbers especially)
 * @constructor
 */
define(function() {

    'use strict';

    var lastStatus = '';
    var appStateElement = document.getElementById('appstate');
    // instead of having a black screen during startup show current steps in appState id
    var updateAppStatus = function(text) {
        try {
            if (typeof appStateElement !== 'undefined') {
                lastStatus = text;
                appStateElement.innerHTML = text;
            }
        } catch(error) {
        }
    };
    
    var getAppStatus = function() {
        return lastStatus;
    };
    
    var config = {
        // versioning
        version: '0.18.12',
        
        // other related information
        UA: (typeof navigator.userAgent !== 'undefined' ? navigator.userAgent : 'Not Specified'),
        // set default resolution, configuration controller will set this properly during runtime
        windowWidth:  1920,
        windowHeight: 1080,

		// 0 - landscape | 90 | 270 - portrait mode
		orientation: '0',

        // displays current status when no media is playing
        // monitoring will fallback on this property
        //status: '',
        getStatus: getAppStatus,
        setStatus: updateAppStatus,

        // store detected platform here for quicker platform specific API usage
        Platform: 'Desktop',
        // monitor settings/specifications
        ProductCode: '',
        Firmware: '',
        // default DUID (will be changed on monitor boot)
        DUID: '',
        // device type for web service (default: 5 - HTML5)
        WebServiceType: '5',
        // device name for web service
        WebServiceName: 'DefaultName',
        // device company id for web service
        WebServiceCompanyID: '',
        // device session id for web service
        WebServiceSessionID: '',
        // sendState2 interval
        WebServiceSendStateInterval: '10000',
        // sendCapture interval
        WebServiceSendCaptureInterval: '20000',
        // interval to check for web service connection sanity (in seconds, default: 300)
        WebServiceCheckConnectionInterval: '300',
        // display download state during sync
        WebServiceDownloadRemaining: 0,
        WebServiceDownloadFailed: 0,
        WebServiceDownloadTotal: 0,
        
        SkipWebServiceRegister: 'false',

        // monitoring update interval
        MonitoringUpdateInterval: '5000',
        
        // force HTML5 fallback for Image Viewer? (default: true)
        forceHTML5ImageViewer: 'true',
        // force HTML5 fallback for Video Player? (default: true)
        forceHTML5VideoPlayer: 'true',
        // use LFD Seamless Play (default: false)
        useLFDPlayer: 'false',
        // use SEF Player (default: false)
        useSEFPlayer: 'false',
        
        // audio mute state on startup (default: false)
        audioMute: 'false',
        
        // remote URL of widget for monitors
        widgetURL: '',
        // common path (this is going to change depending on platform)
        // this is used only for local storage
        commonPath: '',
        // application path
        appPath: '',
        // media path (default: media)
        mediaPath: 'media',
        // application path
        schedulesPath: 'schedules',
        // schedule file - used to point which schedule is playing (default: schedule.xml)
        scheduleFile: 'schedule.xml',
        // actions file (default: actions.json)
        actionsFile: 'actions.json',
        // medias file (default: medias.json)
        mediasFile: 'medias.json',
        // local configuration file path
        configFilePath: '',
        // configuration request timeout in ms
        XHRConfigTimeout: '5000',
        // request timeout in ms
        XHRTimeout: '20000',
        // timeblock check interval (default: 1000ms)
        timeblockInterval: '1000',

        // timezone offset (1 = UTC +1)
        timezone: '1',

        // current source input
        currentSource: 'MEDIA',
        currentSourceDate: 0,

        iptvmode: 0,
        iptvdir: '',

        // enable/disable logger (default: true)
        logger: 'true',
        // show/hide logger on startup (default: false)
        showLogger: 'false',
        // number of logs to display on screen
        displayLogs: '120',
        // limit number of logs in memory (not used yet)
        maxLogs: '500',

        // source of scheduler (set by configuration file)
        DatasRootURL: '',
        // shedule level
        ScheduleLevel: '',
        // shedule starting date
        ScheduleDate: '',
        // HIREN_MODE :
        HirenMode : '',
        // download maximum retry attempt
        downloadRetry: '2',
        // store remote medias locally (default: false)
        useStorageInternal: 'false',
        // skip MD5 checking (default: false)
        skipMD5Check: 'false',
        // preload days number
        preloadDays: '1',
        // on/off timer
        onofftimer: '',
        // copy of on/off timer to avoid setting it each time 
        oldonofftimer: '',

        // time to check for flag.txt update in seconds
        checkFlagInterval: '10',
        // cleanup trigger, percentage limit of free HDD space before launching cleanup
        // (default: 50)
        cleanupLimit: '50',

		// menu mode will transform a schedule with a list of TVTAG (groups)
		// into a menu of timeblocks (default: 0)
		modeMenu: '0',

        // player resolution (NOT USED)
        width:  '1920',
        height: '1080',
    };

    return config;

});
