// JavaScript pour la configuration des conteneurs et l'édition des RecordSets
window.setupContainerConfig = (dotNetRef) => {
    // Retirer tout handler existant pour éviter les doublons
    if (window.xmlNodeClickHandler) {
        document.removeEventListener('click', window.xmlNodeClickHandler);
    }
    
    // Créer et stocker le nouveau handler
    window.xmlNodeClickHandler = (e) => {
        // Vérifier si le clic est sur un nœud XML ou un de ses enfants
        const xmlNode = e.target.closest('.xml-node');
        if (xmlNode) {
            const path = xmlNode.getAttribute('data-path');
            if (path) {
                e.preventDefault();
                e.stopPropagation();
                
                // Retirer la classe selected de tous les nœuds
                document.querySelectorAll('.xml-node.selected').forEach(node => {
                    node.classList.remove('selected');
                });
                
                // Ajouter la classe selected au nœud cliqué
                xmlNode.classList.add('selected');
                
                // Appeler la méthode .NET
                dotNetRef.invokeMethodAsync('OnXmlNodeClick', path);
            }
        }
    };
    
    // Ajouter le handler
    document.addEventListener('click', window.xmlNodeClickHandler);
    
    // Fonction pour mettre à jour la sélection après un refresh
    window.updateXmlSelection = (selectedPath) => {
        document.querySelectorAll('.xml-node').forEach(node => {
            if (node.getAttribute('data-path') === selectedPath) {
                node.classList.add('selected');
            } else {
                node.classList.remove('selected');
            }
        });
    };
};
