// Fichier JavaScript pour gérer la communication avec l'hôte Angular
window.hostCommunication = {
    dotNetRef: null,

    // Initialise la communication
    initializeHostCommunication: function(dotNetReference) {
        this.dotNetRef = dotNetReference;
        
        // Écouter les messages de l'hôte
        window.addEventListener('message', (event) => {
            this.handleMessage(event);
        });

        console.log('Communication avec l\'hôte initialisée');
    },

    // Gère les messages entrants
    handleMessage: function(event) {
        // Optionnel: vérifier l'origine
        // if (event.origin !== 'http://localhost:4200') return;

        if (event.data && event.data.type) {
            console.log('Message reçu de l\'hôte:', event.data);
            
            // Transmettre le message à Blazor
            if (this.dotNetRef) {
                this.dotNetRef.invokeMethodAsync('ReceiveMessage', JSON.stringify(event.data))
                    .catch(error => console.error('Erreur lors de la transmission du message:', error));
            }
        }
    },

    // Envoie un message à l'hôte
    sendMessageToHost: function(messageJson) {
        const message = JSON.parse(messageJson);
        
        // Envoyer au parent (Angular)
        if (window.parent !== window) {
            window.parent.postMessage(message, '*');
            console.log('Message envoyé à l\'hôte:', message);
        }
    }
};

// Fonction globale pour l'initialisation
window.initializeHostCommunication = function(dotNetRef) {
    window.hostCommunication.initializeHostCommunication(dotNetRef);
};

// Fonction globale pour l'envoi de messages
window.sendMessageToHost = function(messageJson) {
    window.hostCommunication.sendMessageToHost(messageJson);
};