﻿function 7Zip-Unzip {
param ( [string]$7zf, [string]$DestinationDirPath )

	set-alias sz "$env:ProgramFiles\7-Zip\7z.exe"
	$7zo = "-aoa -r"
	sz x $7zf "-aoa" "-r" $("-o" + $DestinationDirPath)
}
function 7Zip-UnzipLocal {
param ( [string]$7zf, [string]$DestinationDirPath )

	set-alias sz "$env:ProgramFiles\7-Zip\7z.exe"
	sz x $7zf "-aoa" "-r"
}

if (Test-Path variable:global:tvtoolsDrive) {
	Remove-Variable tvtoolsDrive -Scope Global
}
if (Test-Path variable:global:mediasDrive) {
	Remove-Variable mediasDrive -Scope Global
}
if (Test-Path variable:global:webAccess) {
	Remove-Variable webAccess -Scope Global
}
if (Test-Path variable:global:webAccess) {
    Remove-Variable tvtschedulerService -Scope Global
}

Get-Content unattendUpdate.txt | Where-Object {$_.length -gt 0} | Where-Object {!$_.StartsWith("#")} | ForEach-Object {
     $var = $_.Split('=',2).Trim()
     New-Variable -Scope Global -Name $var[0] -Value $var[1]
}

$tvtoolsPriveFile=$tvtoolsDrive + "tvtools"
if (!(Test-Path $tvtoolsPriveFile)) {
	$file_data = $tvtoolsPriveFile + " n'existe pas! Merci de configurer unattendUpdate.txt"
	throw $file_data
}

$tvtoolsPriveFile=$mediasDrive + "Medias"
if (!(Test-Path $tvtoolsPriveFile)) {
	$file_data = $tvtoolsPriveFile + " n'existe pas! Merci de configurer unattendUpdate.txt"
	throw $file_data
}

$tvtoolsPriveFile=$tvtoolsDrive + "tvtools\prive\updateCloud.txt"
if (Test-Path $tvtoolsPriveFile) {
    Remove-Item $tvtoolsPriveFile
}
New-Item $tvtoolsPriveFile -ItemType file
$tvtschedulerServiceValue="updateService=" + $tvtschedulerService
Add-Content -Path $tvtoolsPriveFile -value $tvtschedulerServiceValue
$serviceUserValue=""
if ("True" -eq $tvtschedulerService)
{
    $serviceUserValue="serviceUser=" + $serviceUser    
}
Add-Content -Path $tvtoolsPriveFile -value $serviceUserValue

$zipFile="$env:ProgramFiles\7-Zip\7z.exe"

$curDir = Get-Location

$tvtoolsPriveFile=$tvtoolsDrive + "tvtools\TVTSchedulerFlat"
cd $tvtoolsPriveFile
Start-Process "TVTScheduler.exe" -ArgumentList "-updateCloud1" -Wait

cd $curDir

$TVTSchedulerUpdateDir=$mediasDrive + "Medias\TVTSchedulerUpdate"
If(!(test-path -PathType Container $TVTSchedulerUpdateDir))
{
     Write-Host "creating directory " $TVTSchedulerUpdateDir
     New-Item -ItemType Directory -Force -Path $TVTSchedulerUpdateDir
}
$TVTSchedulerUpdateFile=$TVTSchedulerUpdateDir + "\miseajour.zip"
Write-Host "copying jr.zip to " $TVTSchedulerUpdateFile
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Copy-Item -Path "jr.zip" -Destination $TVTSchedulerUpdateFile

$TVTSchedulerUpdateFile=$TVTSchedulerUpdateDir + "\7zS.sfx"
$sourceFile=$tvtoolsDrive + "tvtools\prive\dotNET\setupTVToolsServer\7zS.sfx"
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile

$TVTSchedulerUpdateFile=$TVTSchedulerUpdateDir + "\config.txt"
$sourceFile=$tvtoolsDrive + "tvtools\prive\dotNET\setupTVToolsServer\config.txt"
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile

$TVTSchedulerUpdateFile=$TVTSchedulerUpdateDir + "\TVTInstaller.exe"
$sourceFile=$tvtoolsDrive + "tvtools\prive\dotNET\setupTVToolsServer\TVTInstaller.exe"
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile

$TVTSchedulerUpdateFile=$TVTSchedulerUpdateDir + "\7za.exe"
$sourceFile=$tvtoolsDrive + "tvtools\prive\7za.exe"
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile

cd $TVTSchedulerUpdateDir
set-alias sz "$env:ProgramFiles\7-Zip\7z.exe"
sz a "miseajour.zip" -r tvtools
sz a -t7z installTVTools.7z miseajour.zip
sz a -t7z installTVTools.7z 7za.exe
sz a -t7z installTVTools.7z TVTInstaller.exe

cmd /c copy /b 7zS.sfx + config.txt + "installTVTools.7z" installClientTVTools.exe

Remove-Item 7zS.sfx
Remove-Item 7za.exe
Remove-Item config.txt
Remove-Item TVTInstaller.exe
Remove-Item installTVTools.7z

sz a "installClientTVTools.zip" installClientTVTools.exe

$TVTSchedulerUpdateFile=$curDir.Path + "\installClientTVTools.zip"
$sourceFile=$TVTSchedulerUpdateDir + "\installClientTVTools.zip"
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Write-Host "copying" $sourceFile "to" $TVTSchedulerUpdateFile
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile


$TVTSchedulerUpdateFile=$tvtoolsDrive + "tvtools\nv\Upload\tvtools\prive\temp"
If(!(test-path -PathType Container $TVTSchedulerUpdateFile))
{
     Write-Host "creating directory " $TVTSchedulerUpdateFile
     New-Item -ItemType Directory -Force -Path $TVTSchedulerUpdateFile
}
$TVTSchedulerUpdateFile=$tvtoolsDrive + "tvtools\nv\Upload\tvtools\prive\temp\miseajour.zip"
Write-Host "miseajour.zip to" $TVTSchedulerUpdateFile
Copy-Item -Path miseajour.zip -Destination $TVTSchedulerUpdateFile
sz d $TVTSchedulerUpdateFile configWebService.xml -r

$sourceFile=$tvtoolsDrive + "tvtools\prive\lancer.exe"
$TVTSchedulerUpdateFile=$tvtoolsDrive + "tvtools\nv\Upload\tvtools\prive\lancer.exe"
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile

Write-Host "URL pour obtenir l'installeur de client lourd et de diffusion Windows" -ForegroundColor Green
$monurl="url du serveur/TVTSchedulerUpdate/installClientTVTools.zip"
Write-Host $monurl -ForegroundColor Green

cd $curDir

Write-Host "Mise à jour terminée" -ForegroundColor Green
