﻿#Requires -RunAsAdministrator

function 7Zip-Unzip {
param ( [string]$7zf, [string]$DestinationDirPath )

	set-alias sz "$env:ProgramFiles\7-Zip\7z.exe"
	$7zo = "-aoa -r"
	sz x $7zf "-aoa" "-r" $("-o" + $DestinationDirPath)
}
function 7Zip-UnzipLocal {
param ( [string]$7zf, [string]$DestinationDirPath )

	set-alias sz "$env:ProgramFiles\7-Zip\7z.exe"
	sz x $7zf "-aoa" "-r"
}

Start-Transcript log.txt

$zipFile="$env:ProgramFiles\7-Zip\7z.exe"
if (!(Test-Path $zipFile)) {
    Write-Host "7Zip not found, install it"
    Start-Process "7-zip.exe" -Argumentlist '/S' -Wait
}

if (Test-Path variable:global:tvtoolsDrive) {
	Remove-Variable tvtoolsDrive -Scope Global
}
if (Test-Path variable:global:mediasDrive) {
	Remove-Variable mediasDrive -Scope Global
}
if (Test-Path variable:global:sqlServer) {
	Remove-Variable sqlServer -Scope Global
}
if (Test-Path variable:global:sqlServerAccount) {
	Remove-Variable sqlServerAccount -Scope Global
}
if (Test-Path variable:global:webAccess) {
	Remove-Variable webAccess -Scope Global
}
if (Test-Path variable:global:mediasUrl) {
	Remove-Variable mediasUrl -Scope Global
}
if (Test-Path variable:global:serviceAccount) {
	Remove-Variable serviceAccount -Scope Global
}

Get-Content unattend.txt | Where-Object {$_.length -gt 0} | Where-Object {!$_.StartsWith("#")} | ForEach-Object {
     $var = $_.Split('=',2).Trim()
     New-Variable -Scope Global -Name $var[0] -Value $var[1]
}

if ("http://fqdn or IP/medias" -eq $mediasUrl)
{
	throw "you haven't set mediasUrl in unattend.txt. Please read carefully install documentation."
}

if (!(Test-Path "licenceTVTools.lic")) {
	Write-Host "Attention fichier licence non trouvée, la procédure va s'exécuter avec la licence de tests" -ForegroundColor Red
}

if ("True" -eq $sqlServer)
{
	if ("currentUser" -eq $sqlServerAccount)
	{
		$sqlServerAccount=$env:UserDomain + "\" + $env:UserName
	}
	$tvtoolsPriveFile=$tvtoolsDrive + "tvtools\prive\newCloudError.txt"
	if (Test-Path $tvtoolsPriveFile) {
		Remove-Item $tvtoolsPriveFile
	}
	$tvtoolsPriveFile=$tvtoolsDrive + "tvtools\prive\newCloud.txt"
	if (Test-Path $tvtoolsPriveFile) {
		Remove-Item $tvtoolsPriveFile
	}
	New-Item $tvtoolsPriveFile -ItemType file
	$mediasDriveValue="mediasPath=" + $mediasDrive + "Medias"
	$mediasUrlValue="mediasUrl=" + $mediasUrl
	$sqlServerAccountValue="sqlServerAccount=" + $sqlServerAccount
	$serviceAccountValue="serviceAccount=" + $serviceAccount
	Add-Content -Path $tvtoolsPriveFile -value $mediasDriveValue
	Add-Content -Path $tvtoolsPriveFile -value $mediasUrlValue
	Add-Content -Path $tvtoolsPriveFile -value $sqlServerAccountValue
	Add-Content -Path $tvtoolsPriveFile -value $serviceAccountValue
}

if (Test-Path "licenceTVTools.lic") {
	$tvtoolsPriveDir=$tvtoolsDrive + "tvtools\prive"
	Copy-Item -Path "licenceTVTools.lic" -Destination $tvtoolsPriveDir
} else {
	$tvtoolsPriveDir=$tvtoolsDrive + "tvtools\prive\licenceTVTools.lic"
	Copy-Item -Path "licenceTVToolsDefaut.lic" -Destination $tvtoolsPriveDir
}

$curDir = Get-Location

$tvtoolsPriveFile=$tvtoolsDrive + "tvtools\TVTSchedulerFlat"
cd $tvtoolsPriveFile
Start-Process "TVTScheduler.exe" -Wait

$tvtoolsPriveFile=$tvtoolsDrive + "tvtools\prive\newCloudError.txt"
if (Test-Path $tvtoolsPriveFile) {
	$file_data = Get-Content $tvtoolsPriveFile
	Remove-Item $tvtoolsPriveFile
	Write-Host $file_data -ForegroundColor Red
	Write-Host "Procédure avortée" -ForegroundColor Red
} else {
cd $curDir
$TVTSchedulerUpdateDir=$mediasDrive + "Medias\TVTSchedulerUpdate"
If(!(test-path -PathType Container $TVTSchedulerUpdateDir))
{
     Write-Host "creating directory " $TVTSchedulerUpdateDir
     New-Item -ItemType Directory -Force -Path $TVTSchedulerUpdateDir
}
$TVTSchedulerUpdateFile=$TVTSchedulerUpdateDir + "\miseajour.zip"
Write-Host "copying jr.zip to " $TVTSchedulerUpdateFile
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Copy-Item -Path "jr.zip" -Destination $TVTSchedulerUpdateFile

$TVTSchedulerUpdateFile=$TVTSchedulerUpdateDir + "\7zS.sfx"
$sourceFile=$tvtoolsDrive + "tvtools\prive\dotNET\setupTVToolsServer\7zS.sfx"
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile

$TVTSchedulerUpdateFile=$TVTSchedulerUpdateDir + "\config.txt"
$sourceFile=$tvtoolsDrive + "tvtools\prive\dotNET\setupTVToolsServer\config.txt"
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile

$TVTSchedulerUpdateFile=$TVTSchedulerUpdateDir + "\TVTInstaller.exe"
$sourceFile=$tvtoolsDrive + "tvtools\prive\dotNET\setupTVToolsServer\TVTInstaller.exe"
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile

$TVTSchedulerUpdateFile=$TVTSchedulerUpdateDir + "\7za.exe"
$sourceFile=$tvtoolsDrive + "tvtools\prive\7za.exe"
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile

cd $TVTSchedulerUpdateDir
set-alias sz "$env:ProgramFiles\7-Zip\7z.exe"
sz a "miseajour.zip" -r tvtools
sz a -t7z installTVTools.7z miseajour.zip
sz a -t7z installTVTools.7z 7za.exe
sz a -t7z installTVTools.7z TVTInstaller.exe

cmd /c copy /b 7zS.sfx + config.txt + "installTVTools.7z" installClientTVTools.exe

Remove-Item 7zS.sfx
Remove-Item 7za.exe
Remove-Item config.txt
Remove-Item TVTInstaller.exe
Remove-Item installTVTools.7z

sz a "installClientTVTools.zip" installClientTVTools.exe

$TVTSchedulerUpdateFile=$curDir.Path + "\installClientTVTools.zip"
$sourceFile=$TVTSchedulerUpdateDir + "\installClientTVTools.zip"
If((test-path $TVTSchedulerUpdateFile))
{
	Remove-Item $TVTSchedulerUpdateFile
}
Write-Host "copying" $sourceFile "to" $TVTSchedulerUpdateFile
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile


$TVTSchedulerUpdateFile=$tvtoolsDrive + "tvtools\nv\Upload\tvtools\prive\temp"
If(!(test-path -PathType Container $TVTSchedulerUpdateFile))
{
     Write-Host "creating directory " $TVTSchedulerUpdateFile
     New-Item -ItemType Directory -Force -Path $TVTSchedulerUpdateFile
}
$TVTSchedulerUpdateFile=$tvtoolsDrive + "tvtools\nv\Upload\tvtools\prive\temp\miseajour.zip"
Write-Host "miseajour.zip to" $TVTSchedulerUpdateFile
Copy-Item -Path miseajour.zip -Destination $TVTSchedulerUpdateFile
sz d $TVTSchedulerUpdateFile configWebService.xml -r

$sourceFile=$tvtoolsDrive + "tvtools\prive\lancer.exe"
$TVTSchedulerUpdateFile=$tvtoolsDrive + "tvtools\nv\Upload\tvtools\prive\lancer.exe"
Copy-Item -Path $sourceFile -Destination $TVTSchedulerUpdateFile

Write-Host "URL pour obtenir l'installeur de client lourd et de diffusion Windows" -ForegroundColor Green
$monurl=$mediasUrl + "/TVTSchedulerUpdate/installClientTVTools.zip"
Write-Host $monurl -ForegroundColor Green

}
cd $curDir

Write-Host "Mise à jour terminée" -ForegroundColor Green


