// Graphiques pour le Dashboard IA
let costChart = null;
let usageChart = null;

window.initAICharts = function() {
    // Initialiser le graphique des coûts
    const costCtx = document.getElementById('costChart');
    if (costCtx) {
        costChart = new Chart(costCtx, {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    label: 'Coûts journaliers (€)',
                    data: [],
                    borderColor: 'rgb(75, 192, 192)',
                    backgroundColor: 'rgba(75, 192, 192, 0.1)',
                    tension: 0.1,
                    fill: true
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'top'
                    },
                    title: {
                        display: false
                    },
                    tooltip: {
                        mode: 'index',
                        intersect: false,
                        callbacks: {
                            label: function(context) {
                                return context.dataset.label + ': €' + context.parsed.y.toFixed(2);
                            }
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return '€' + value.toFixed(2);
                            }
                        }
                    }
                }
            }
        });
    }

    // Initialiser le graphique de répartition
    const usageCtx = document.getElementById('usageChart');
    if (usageCtx) {
        usageChart = new Chart(usageCtx, {
            type: 'doughnut',
            data: {
                labels: [],
                datasets: [{
                    data: [],
                    backgroundColor: [
                        'rgba(255, 99, 132, 0.8)',
                        'rgba(54, 162, 235, 0.8)',
                        'rgba(255, 206, 86, 0.8)',
                        'rgba(75, 192, 192, 0.8)',
                        'rgba(153, 102, 255, 0.8)',
                        'rgba(255, 159, 64, 0.8)'
                    ],
                    borderColor: [
                        'rgba(255, 99, 132, 1)',
                        'rgba(54, 162, 235, 1)',
                        'rgba(255, 206, 86, 1)',
                        'rgba(75, 192, 192, 1)',
                        'rgba(153, 102, 255, 1)',
                        'rgba(255, 159, 64, 1)'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'right'
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                const label = context.label || '';
                                const value = context.parsed || 0;
                                const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                const percentage = ((value / total) * 100).toFixed(1);
                                return label + ': €' + value.toFixed(2) + ' (' + percentage + '%)';
                            }
                        }
                    }
                }
            }
        });
    }
};

window.updateAICharts = function(costLabels, costData, appLabels, appData) {
    // Mettre à jour le graphique des coûts
    if (costChart) {
        costChart.data.labels = costLabels;
        costChart.data.datasets[0].data = costData;
        costChart.update();
    }

    // Mettre à jour le graphique de répartition
    if (usageChart) {
        usageChart.data.labels = appLabels;
        usageChart.data.datasets[0].data = appData;
        usageChart.update();
    }
};

// Fonction pour détruire les graphiques (cleanup)
window.disposeAICharts = function() {
    if (costChart) {
        costChart.destroy();
        costChart = null;
    }
    if (usageChart) {
        usageChart.destroy();
        usageChart = null;
    }
};