// Blazor Server Auto-Reconnect Handler
// Affiche un modal et tente de recharger la page toutes les 15 secondes

const reloadIntervalMs = 15000;  // 15 secondes entre chaque tentative de reload
let reloadTimer = null;
let attemptCount = 0;

console.log('[Blazor Reconnect] Script loaded and starting Blazor...');

Blazor.start().then(() => {
    console.log('[Blazor Reconnect] Blazor started, setting up reconnect callback...');

    const reconnectHandler = Blazor.defaultReconnectionHandler;

    if (!reconnectHandler) {
        console.error('[Blazor Reconnect] No default reconnection handler found!');
        return;
    }

    console.log('[Blazor Reconnect] Default reconnection handler found');

    // Remplacer par notre logique simple : afficher modal + reload périodique
    reconnectHandler._reconnectCallback = async function(d) {
        console.log('[Blazor] ⚠️ Connection lost - starting periodic page reload...');

        // Afficher le modal
        showReconnectModal();

        attemptCount = 0;

        // Fonction pour tenter de recharger la page
        const attemptReload = () => {
            attemptCount++;
            console.log(`[Blazor] 🔄 Reload attempt ${attemptCount}...`);
            updateAttemptNumber(attemptCount);

            // Recharger la page - si le serveur est de retour, cela fonctionnera
            location.reload();
        };

        // Première tentative immédiate après 15 secondes
        reloadTimer = setInterval(attemptReload, reloadIntervalMs);

        // Retourner false pour indiquer qu'on ne gère pas la reconnexion SignalR
        // (on recharge la page à la place)
        return false;
    };

    console.log('[Blazor Reconnect] Custom reconnect callback installed');
});

// Afficher le modal de reconnexion
function showReconnectModal() {
    console.log('[Blazor] 🔍 showReconnectModal() called');
    const modal = document.getElementById('components-reconnect-modal');
    console.log('[Blazor] Modal found:', modal !== null);

    if (modal) {
        console.log('[Blazor] Showing modal with display: flex');
        modal.style.display = 'flex';
        console.log('[Blazor] Modal display:', modal.style.display);

        // Réafficher la section "show" et cacher "failed"
        const showDiv = document.querySelector('.components-reconnect-show');
        const failedDiv = document.querySelector('.components-reconnect-failed');
        if (showDiv) showDiv.style.display = 'block';
        if (failedDiv) failedDiv.style.display = 'none';
    } else {
        console.error('[Blazor] ❌ Modal element NOT FOUND in DOM!');
    }
}

// Cacher le modal de reconnexion
function hideReconnectModal() {
    console.log('[Blazor] 🔍 hideReconnectModal() called');
    const modal = document.getElementById('components-reconnect-modal');
    if (modal) {
        modal.style.display = 'none';
        console.log('[Blazor] Modal hidden');
    }
}

// Mettre à jour le numéro de tentative
function updateAttemptNumber(current) {
    console.log('[Blazor] 🔍 Updating attempt number to:', current);
    const attemptSpan = document.getElementById('attempt-number');
    if (attemptSpan) {
        attemptSpan.textContent = current;
        console.log('[Blazor] Attempt number updated');
    } else {
        console.error('[Blazor] ❌ Attempt number span NOT FOUND!');
    }
}

// Afficher la section "failed" du modal
function showFailedModal() {
    console.log('[Blazor] 🔍 showFailedModal() called');
    const showDiv = document.querySelector('.components-reconnect-show');
    const failedDiv = document.querySelector('.components-reconnect-failed');

    console.log('[Blazor] Show div found:', showDiv !== null);
    console.log('[Blazor] Failed div found:', failedDiv !== null);

    if (showDiv) showDiv.style.display = 'none';
    if (failedDiv) failedDiv.style.display = 'block';
}
