/**
 * Fonctions JavaScript pour le système de déploiement OTA
 */

/**
 * Télécharge un fichier Excel en appelant un endpoint via POST
 * @param {string} url - URL de l'endpoint
 * @param {string} jsonPayload - Payload JSON à envoyer
 */
window.downloadExcelFile = async function (url, jsonPayload) {
    try {
        const response = await fetch(url, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: jsonPayload
        });

        if (!response.ok) {
            const error = await response.text();
            console.error('Export Excel failed:', error);
            alert('Erreur lors de l\'export Excel: ' + error);
            return;
        }

        // Récupérer le nom du fichier depuis les headers
        const contentDisposition = response.headers.get('Content-Disposition');
        let filename = 'Familles_OTA.xlsx';

        if (contentDisposition) {
            const filenameMatch = contentDisposition.match(/filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/);
            if (filenameMatch && filenameMatch[1]) {
                filename = filenameMatch[1].replace(/['"]/g, '');
            }
        }

        // Créer un blob et déclencher le téléchargement
        const blob = await response.blob();
        const downloadUrl = window.URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = downloadUrl;
        a.download = filename;
        document.body.appendChild(a);
        a.click();

        // Cleanup
        window.URL.revokeObjectURL(downloadUrl);
        document.body.removeChild(a);

        console.log('Excel file downloaded successfully:', filename);
    } catch (error) {
        console.error('Error downloading Excel file:', error);
        alert('Erreur lors du téléchargement: ' + error.message);
    }
};
