window.DevExpressInit = {
    isReady: false,
    
    checkReady: function() {
        return typeof DxBlazor !== 'undefined' && window.DxBlazor;
    },
    
    waitForReady: function(callback) {
        if (this.checkReady()) {
            callback();
        } else {
            setTimeout(() => this.waitForReady(callback), 100);
        }
    },
    
    initialize: function() {
        console.log('Initializing DevExpress...');
        
        if (typeof Blazor !== 'undefined') {
            Blazor.start().then(() => {
                console.log('Blazor started');
                this.isReady = true;
            });
        }
    }
};

// Initialize when DOM is ready
document.addEventListener('DOMContentLoaded', function() {
    window.DevExpressInit.initialize();
});
