window.dxInitHelper = {
    waitForDx: function(callback, attempts = 0) {
        if (typeof DxBlazor !== 'undefined' && DxBlazor) {
            console.log('DevExpress loaded successfully');
            if (callback) callback();
        } else if (attempts < 50) {
            console.log('Waiting for DevExpress... attempt ' + (attempts + 1));
            setTimeout(() => this.waitForDx(callback, attempts + 1), 100);
        } else {
            console.error('DevExpress failed to load after 5 seconds');
        }
    }
};

// Auto-check on load
document.addEventListener('DOMContentLoaded', function() {
    window.dxInitHelper.waitForDx();
});

// Also check when Blazor is ready
if (window.Blazor) {
    window.Blazor.start().then(() => {
        window.dxInitHelper.waitForDx();
    });
}
