// Helper pour gérer l'authentification JWT dans les pages Blazor
window.TVToolsAuth = {
    getToken: function() {
        return localStorage.getItem('tvtools_jwt_token');
    },
    
    setToken: function(token) {
        localStorage.setItem('tvtools_jwt_token', token);
    },
    
    hasToken: function() {
        return !!localStorage.getItem('tvtools_jwt_token');
    },
    
    clearToken: function() {
        localStorage.removeItem('tvtools_jwt_token');
    },
    
    // Intercepter toutes les requêtes fetch pour ajouter le header Authorization
    setupFetchInterceptor: function() {
        const originalFetch = window.fetch;
        window.fetch = function(...args) {
            let [url, config] = args;
            config = config || {};
            config.headers = config.headers || {};
            
            const token = TVToolsAuth.getToken();
            if (token && !config.headers['Authorization']) {
                config.headers['Authorization'] = 'Bearer ' + token;
            }
            
            return originalFetch.apply(this, [url, config]);
        };
    },
    
    // Configurer XMLHttpRequest pour les téléchargements
    configureDownload: function(xhr) {
        const token = TVToolsAuth.getToken();
        if (token) {
            xhr.setRequestHeader('Authorization', 'Bearer ' + token);
        }
    }
};

// Initialiser l'intercepteur au chargement
if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', function() {
        TVToolsAuth.setupFetchInterceptor();
    });
} else {
    TVToolsAuth.setupFetchInterceptor();
}
